<?php session_start(); ?>

<div class="page-content header-clear-medium">
    <div class="card card-style">
        <div class="content">
            <p class="mb-0 text-center font-600 color-highlight">Transfer Funds</p>
            <h1 class="text-center">Withdraw to bank</h1>

            <?php
            $accountValid = false;
            $accountName = '';
            $accountError = '';

            if (isset($_GET['account_number']) && isset($_GET['bank_code'])) {
                $_SESSION['account_number'] = $_GET['account_number'];
                $_SESSION['bank_code'] = $_GET['bank_code'];

                // Get access token
                $curl = curl_init();
                curl_setopt_array($curl, [
                    CURLOPT_URL => 'https://api.safehavenmfb.com/oauth2/token',
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_POST => true,
                    CURLOPT_POSTFIELDS => 'grant_type=client_credentials&client_id=e4c9bf70d6f78ea76f877a3423a9a3a4&client_assertion_type=urn:ietf:params:oauth:client-assertion-type:jwt-bearer&client_assertion=eyJhbGciOiJSUzI1NiIsInR5cCI6IkpXVCJ9.eyJpc3MiOiJodHRwczovL2twb2ludC5jb20ubmciLCJzdWIiOiJlNGM5YmY3MGQ2Zjc4ZWE3NmY4NzdhMzQyM2E5YTNhNCIsImF1ZCI6Imh0dHBzOi8vYXBpLnNhZmVoYXZlbm1mYi5jb20iLCJpYXQiOjE3NDIxMTMxMzgsImV4cCI6MTc3MzY0OTA4OX0.dQi_viEB9NGi11qnOV5adYzhe4uEtyONEZzsHvfp-Pm8VkLv83DNA9rH-scSpMsxcTyb1Lq2jck19Pv-0JHHsBxz-UKlm54oF8V3NO_bs4_01lLa25Bz84G4v9mPTMwnZGHsOXnKXv6E-Jat82fKyqXcjD593y76sm1mhybsRpE',
                    CURLOPT_HTTPHEADER => ['Content-Type: application/x-www-form-urlencoded']
                ]);
                $response = curl_exec($curl);
                curl_close($curl);

                $tokenData = json_decode($response, true);
                $accessToken = $tokenData['access_token'];
                $clientId = $tokenData['ibs_client_id'];

                // Name enquiry
                $data = [
                    "bankCode" => $_GET['bank_code'],
                    "accountNumber" => $_GET['account_number']
                ];
                $curl = curl_init();
                curl_setopt_array($curl, [
                    CURLOPT_URL => 'https://api.safehavenmfb.com/transfers/name-enquiry',
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_POST => true,
                    CURLOPT_POSTFIELDS => json_encode($data),
                    CURLOPT_HTTPHEADER => [
                        "ClientID: $clientId",
                        'Content-Type: application/json',
                        "Authorization: Bearer $accessToken"
                    ]
                ]);
                $response = curl_exec($curl);
                curl_close($curl);

                $result = json_decode($response, true);

                if ($result['statusCode'] == 200) {
                    $accountValid = true;
                    $accountName = $result['data']['accountName'];
                    $_SESSION['account_name'] = $accountName;
                     $_SESSION['session_id'] = $result['data']['sessionId'];
                     

                } else {
                    $accountError = "Invalid Account Details.";
                }
            }

            ?>

<?php if ($accountValid): ?>

           
                <form method="post" class="transferForm" action="withdraw-to-bank">
<?php else: ?>
    <form method="get" action="">
<?php endif; ?>
                <fieldset>
                    <!-- Account Number -->
                    <div class="input-style input-style-always-active has-borders validate-field mb-4">
                        <label for="accNum" class="color-theme opacity-80 font-700 font-12">Account Number</label>
                        <input type="number" name="account_number"   placeholder="Account Number"
                               value="<?= $_SESSION['account_number'] ?? '' ?>"
                               id="walletreceiverinput" class="round-small" required/>
                    </div>

                    <!-- Bank Select -->
                    <div class="input-style input-style-always-active has-borders mb-4">
                        <label for="bank" class="color-theme opacity-80 font-700 font-12">Bank</label>
                        
                        <?php if ($accountValid){ ?>
                        
                        <input type="text" readonly value="bank name">
                        

                        <?php }else{ ?>
                        
                        <select name="bank_code" required  readonly >
                            <option value="" disabled <?= !isset($_SESSION['bank_code']) ? 'selected' : '' ?>>Select Bank</option>
                            
    
                            <?php
                            // Fetch bank list
                            $curl = curl_init();
                            curl_setopt_array($curl, [
                                CURLOPT_URL => 'https://api.safehavenmfb.com/oauth2/token',
                                CURLOPT_RETURNTRANSFER => true,
                                CURLOPT_POST => true,
                                CURLOPT_POSTFIELDS => 'grant_type=client_credentials&client_id=e4c9bf70d6f78ea76f877a3423a9a3a4&client_assertion_type=urn:ietf:params:oauth:client-assertion-type:jwt-bearer&client_assertion=eyJhbGciOiJSUzI1NiIsInR5cCI6IkpXVCJ9.eyJpc3MiOiJodHRwczovL2twb2ludC5jb20ubmciLCJzdWIiOiJlNGM5YmY3MGQ2Zjc4ZWE3NmY4NzdhMzQyM2E5YTNhNCIsImF1ZCI6Imh0dHBzOi8vYXBpLnNhZmVoYXZlbm1mYi5jb20iLCJpYXQiOjE3NDIxMTMxMzgsImV4cCI6MTc3MzY0OTA4OX0.dQi_viEB9NGi11qnOV5adYzhe4uEtyONEZzsHvfp-Pm8VkLv83DNA9rH-scSpMsxcTyb1Lq2jck19Pv-0JHHsBxz-UKlm54oF8V3NO_bs4_01lLa25Bz84G4v9mPTMwnZGHsOXnKXv6E-Jat82fKyqXcjD593y76sm1mhybsRpE',
                                CURLOPT_HTTPHEADER => ['Content-Type: application/x-www-form-urlencoded']
                            ]);
                            $response = curl_exec($curl);
                            curl_close($curl);

                            $tokenData = json_decode($response, true);
                            $accessToken = $tokenData['access_token'];
                            $clientId = $tokenData['ibs_client_id'];

                            $curl = curl_init();
                            curl_setopt_array($curl, [
                                CURLOPT_URL => 'https://api.safehavenmfb.com/transfers/banks',
                                CURLOPT_RETURNTRANSFER => true,
                                CURLOPT_HTTPHEADER => [
                                    "ClientID: $clientId",
                                    "Authorization: Bearer $accessToken"
                                ]
                            ]);
                            $response = curl_exec($curl);
                            curl_close($curl);
                            $banks = json_decode($response, true)['data'] ?? [];

                            foreach ($banks as $bank) {
                                $selected = ($_SESSION['bank_code'] ?? '') == $bank['bankCode'] ? 'selected' : '';
                                  if ($selected) {
                               $_SESSION['bank_name'] = $bank['name']; 
                         }
                                echo "<option value='{$bank['bankCode']}' $selected>{$bank['name']}</option>";
                                
                            
                            }
                            ?>
                        </select>
                        
                         <?php } ?>
                    </div>

                    <!-- Show account name or error -->
                    <?php if ($accountValid): ?>
                        <p class='text-success text-md'>Account Name: <?= htmlspecialchars($accountName) ?></p>
                        <input type="hidden" id="acc_name" value="<?= $accountName ?>" name="acc_name">
                    <?php elseif (!empty($accountError)): ?>
                        <p class='text-danger text-md'><?= $accountError ?></p>
                    <?php endif; ?>

                    <!-- Amount (Only if account is valid) -->
                    <?php if ($accountValid): ?>
                    
                        <input type="hidden" name="withdraw-to-bank" value="yes">
                        
                        <input type="hidden" name="bank_name" value="<?= htmlspecialchars($_SESSION['bank_name'] ?? '') ?>">

                        <div class="input-style input-style-always-active has-borders validate-field mb-4">
                            <label for="amount" class="color-theme opacity-80 font-700 font-12">Amount</label>
                            <input type="number" name="amount" placeholder="Amount" class="round-small" id="wallettransferamount" required/>
                        </div>
                        
                       <input type="hidden" name="sessionId" value="<?= $_SESSION['session_id'] ?>">
                        
                         <div class="input-style input-style-always-active has-borders validate-field mb-4">
                            <label for="amount" class="color-theme opacity-80 font-700 font-12">Wallet Pin</label>
                            <input type="number" name="transkey" placeholder="Pin" class="round-small" id="walletPin" required/>
                        </div>

                        <input type="hidden" name="bank_code" value="<?= $_SESSION['bank_code'] ?>">
                        <input type="hidden" name="account_number" value="<?= $_SESSION['account_number'] ?>">

                        <div class="form-button">
                            <button type="submit" name="perform-transfer"
                                    class="btn btn-full btn-l font-600 font-15 gradient-highlight mt-4 rounded-s">
                                Continue
                            </button>
                        </div>
                    <?php else: ?>
                        <div class="form-button">
                            <button type="submit"
                                    class="btn btn-full btn-l font-600 font-15 gradient-highlight mt-4 rounded-s">
                                Validate Account
                            </button>
                        </div>
                    <?php endif; ?>
                </fieldset>
            </form>
        </div>
    </div>
</div>
