<?php
session_start();
require_once 'path/to/Model.php';

header('Content-Type: application/json');

if (!isset($_SESSION['subscriber_id'])) {
    echo json_encode(['status' => 'error', 'message' => 'Subscriber not logged in']);
    exit;
}

$subscriberId = $_SESSION['subscriber_id'];
$model = new Model();
$dbh = $model->connect();

if (!isset($_FILES['profileImage']) || $_FILES['profileImage']['error'] !== UPLOAD_ERR_OK) {
    echo json_encode(['status' => 'error', 'message' => 'No file uploaded or upload error']);
    exit;
}

$file = $_FILES['profileImage'];
$allowed = ['jpg','jpeg','png','gif'];
$ext = strtolower(pathinfo($file['name'], PATHINFO_EXTENSION));

if (!in_array($ext, $allowed)) {
    echo json_encode(['status' => 'error', 'message' => 'Invalid file type']);
    exit;
}

$uploadDir = 'uploads/avatars/';
if (!is_dir($uploadDir)) {
    mkdir($uploadDir, 0755, true);
}

$newFileName = uniqid("avatar_", true) . '.' . $ext;
$targetPath = $uploadDir . $newFileName;

if (!move_uploaded_file($file['tmp_name'], $targetPath)) {
    echo json_encode(['status' => 'error', 'message' => 'Failed to move uploaded file']);
    exit;
}

// Update DB
$sql = "UPDATE subscribers SET avatar = :avatar WHERE id = :id";
$stmt = $dbh->prepare($sql);
$stmt->bindParam(':avatar', $targetPath);
$stmt->bindParam(':id', $subscriberId);

if ($stmt->execute()) {
    echo json_encode(['status' => 'success', 'imageUrl' => $targetPath]);
} else {
    echo json_encode(['status' => 'error', 'message' => 'Failed to update database']);
}
