<!DOCTYPE html>
<html>
<head>
    <title>XSS Detection</title>
    <style>
        .danger {
            color: red;
            font-weight: bold;
        }
        .delete-btn, .keep-btn {
            padding: 10px;
            border-radius: 50px;
            border: none;
        }
        .delete-btn {
            background-color: red;
            color: white;
        }
        .keep-btn {
            background-color: green;
            color: white;
            border: none;
        }
    </style>
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
</head>
<body>
<?php
// Database credentials
$hostname = "localhost";
$username = "databser_Ds";
$password = "i-ps6S},vMe6";
$database = "databser_Ds";

// Establish a connection to the database
$conn = new mysqli($hostname, $username, $password, $database);

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Retrieve all tables
$tables_query = mysqli_prepare($conn, "SHOW TABLES");
mysqli_stmt_execute($tables_query);
$tables_result = mysqli_stmt_get_result($tables_query);
$tables = [];
while ($table_row = mysqli_fetch_row($tables_result)) {
    $tables[] = $table_row[0];
}

// Initialize response string
$response = '';
$xssData = []; // Array to hold detected XSS data

// Loop through each table
foreach ($tables as $table) {
    // Retrieve all fields from the current table
    $fields_query = mysqli_prepare($conn, "SHOW COLUMNS FROM $table");
    mysqli_stmt_execute($fields_query);
    $fields_result = mysqli_stmt_get_result($fields_query);
    $fields = [];
    while ($field_row = mysqli_fetch_assoc($fields_result)) {
        $fields[] = $field_row['Field'];
    }

// Fetch data from the current table
$data_query = mysqli_prepare($conn, "SELECT * FROM $table");
mysqli_stmt_execute($data_query);
$data_result = mysqli_stmt_get_result($data_query);
while ($row = mysqli_fetch_assoc($data_result)) {
    // Loop through each field's data
    foreach ($fields as $field) {
        // Get field's data, ID, and email (change 'email' to your actual email field name)
        $data = $row[$field];
        $id = $row['id']; // Change 'id' to your actual primary key field name
        $email = $row['email']; // Change 'email' to your actual email field name

        // Check for potential XSS
        if (preg_match("/<script|<\/script|javascript|onload|onerror/i", $data)) {
            // Construct response for potentially harmful data
            $xssData[] = [
                'id' => $id,
                'email' => $email,
                'table' => $table,
                'field' => $field,
                'data' => $data,
                
            ];
            $response .= "<li><br><br>";
            $response .= "<li><i class='fas fa-database'></i> Table: <b>$table</b></li>";
            $response .= "<li><i class='fas fa-home'></i> Field: <b>$field</b></li>";
            $response .= "<li><i class='fas fa-id-card'></i> ID: <b>$id</b></li>";
            $response .= "<li><i class='fas fa-envelope'></i> Email: <b>$email</b></li>";
            $response .= "<li>";
            $response .= "<button class='keep-btn'>Keep</button>";
            $response .= "<button class='delete-btn'>Delete</button>";
            $response .= "</li>";
        }
    }
}
}

// If no danger detected, show a message
if (empty($response)) {
    $response = "<div>No potential XSS or malicious content detected.</div>";
}

// Close the connection
mysqli_close($conn);

// Display detected XSS data in raw format
echo "<div>Detected XSS Data:</div>";
echo "<pre>";
print_r($xssData);
echo "</pre>";

// Display the formatted response
echo "<ul class='danger'><li><i class='fas fa-exclamation-triangle'></i> Danger Found!!</li></ul>";
echo "<ul>$response</ul>";
?>
<script>
    $(document).ready(function() {
        $('.delete-btn').click(function() {
            if (confirm("This action will permanently delete this data from the database. Press 'OK' to proceed or 'Cancel' to return.")) {
                let id = $(this).closest('li').find('.id-value').text(); // Fetch the ID value
                $.ajax({
                    type: 'POST',
                    url: 'Delete.php',
                    data: { id: id },
                    success: function(data) {
                        alert(data); // Display response from Delete.php
                        location.reload(); // Reload the page after deletion
                    },
                    error: function(xhr, status, error) {
                        alert("Error occurred while deleting: " + error); // Display error message
                    }
                });
            }
        });

        $('.keep-btn').click(function() {
            alert("Credentials remain untouched. Kept successful.");
        });
    });
</script>
</body>
</html>