<?php
require_once(__DIR__ . '/../../core/Models/SubscriberModel.php');
$model = new SubscriberModel();
$userId = $_SESSION["loginId"];
$savings = $model->getUserSavings($userId);

// Calculate stats
$totalSavings = 0;
$activeGoals = 0;
$completedGoals = 0;

foreach ($savings as $saving) {
    if ($saving['status'] === 'active') {
        $totalSavings += $saving['amount'];
        $activeGoals++;
    } elseif ($saving['status'] === 'completed') {
        $completedGoals++;
    }
}
?>
<?php if (isset($_GET['msg'])): ?>
  <div class="alert alert-info text-center">
    <?php echo htmlspecialchars($_GET['msg']); ?>
  </div>
<?php endif; ?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Smart Savings - Lock Funds</title>
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Bootstrap Icons -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
</head>
<!-- Smart Savings Content Partial -->
<div style="background: linear-gradient(135deg, #faf5ff 0%, #fdf2f8 50%, #eef2ff 100%); min-height: 100vh;">
    <div class="container py-5">
        <!-- Header -->
        <div class="text-center mb-5">
            <div class="d-flex align-items-center justify-content-center gap-3 mb-4">
                <div style="width: 60px; height: 60px; background: linear-gradient(135deg, #9333ea, #db2777); border-radius: 50%; display: flex; align-items: center; justify-content: center;">
                    <i class="bi bi-piggy-bank fs-3 text-white"></i>
                </div>
                <h1 class="display-4 fw-bold mb-0" style="background: linear-gradient(135deg, #9333ea, #db2777); -webkit-background-clip: text; -webkit-text-fill-color: transparent; background-clip: text;">Smart Savings</h1>
            </div>
            <p class="text-muted fs-5">Lock your funds and watch your savings grow</p>
        </div>

        <!-- Stats Card -->
        <div class="card border-0 shadow-lg mb-5" style="background: linear-gradient(135deg, #9333ea, #db2777);">
            <div class="card-body p-4">
                <div class="row g-4">
                    <div class="col-md-4 text-center text-white">
                        <i class="bi bi-graph-up fs-2 mb-2" style="opacity: 0.75;"></i>
                        <p class="small mb-1" style="color: #fff;">Total Active Savings</p>
                        <p class="fs-4 fw-bold mb-0" style="color: #fff;">₦<?php echo number_format($totalSavings, 2); ?></p>
                    </div>
                    <div class="col-md-4 text-center text-white">
                        <i class="bi bi-piggy-bank fs-2 mb-2" style="opacity: 0.75;"></i>
                        <p class="small mb-1" style="color: #fff;">Active Goals</p>
                        <p class="fs-4 fw-bold mb-0" style="color: #fff;"><?php echo $activeGoals; ?></p>
                    </div>
                    <div class="col-md-4 text-center text-white">
                        <i class="bi bi-calendar-check fs-2 mb-2" style="opacity: 0.75;"></i>
                        <p class="small mb-1" style="color: #fff;">Completed Goals</p>
                        <p class="fs-4 fw-bold mb-0" style="color: #fff;"><?php echo $completedGoals; ?></p>
                    </div>
                </div>
            </div>
        </div>

        <div class="row g-4">
            <!-- Create Savings Form -->
            <div class="col-lg-6">
                <div class="card border-0 shadow-lg h-100" style="transition: transform 0.2s ease, box-shadow 0.2s ease;">
                    <div class="card-header border-0" style="background: linear-gradient(135deg, #faf5ff, #fdf2f8); border-radius: 0.5rem 0.5rem 0 0 !important;">
                        <h5 class="card-title mb-1" style="color: #6b21a8;">
                            <i class="bi bi-currency-dollar me-2"></i>
                            Create New Savings Goal
                        </h5>
                        <p class="card-text text-muted small mb-0">
                            Lock your funds for a specific period to reach your savings goals
                        </p>
                    </div>
                    <div class="card-body p-4">
                        <form id="savingsForm" method="post" action="index.php?url=savings">
                            <input type="hidden" name="create-savings" value="1">
                            <div class="mb-4">
                                <label for="title" class="form-label fw-medium text-dark">Savings Title</label>
                                <input type="text" class="form-control" id="title" name="title" 
                                       placeholder="e.g. Emergency Fund, Vacation, School Fees" required maxlength="50"
                                       style="border: 1px solid #e5e7eb; border-radius: 0.5rem; padding: 0.75rem; transition: all 0.2s ease;"
                                       onfocus="this.style.borderColor='#9333ea'; this.style.boxShadow='0 0 0 0.2rem rgba(147, 51, 234, 0.25)';"
                                       onblur="this.style.borderColor='#e5e7eb'; this.style.boxShadow='none';">
                            </div>

                            <div class="mb-4">
                                <label for="amount" class="form-label fw-medium text-dark">Amount to Save (₦)</label>
                                <input type="number" class="form-control" id="amount" name="amount" 
                                       placeholder="Enter amount" required min="1"
                                       style="border: 1px solid #e5e7eb; border-radius: 0.5rem; padding: 0.75rem; transition: all 0.2s ease;"
                                       onfocus="this.style.borderColor='#9333ea'; this.style.boxShadow='0 0 0 0.2rem rgba(147, 51, 234, 0.25)';"
                                       onblur="this.style.borderColor='#e5e7eb'; this.style.boxShadow='none';">
                            </div>

                            <div class="mb-4">
                                <label for="period" class="form-label fw-medium text-dark">Lock Period</label>
                                <select class="form-select" id="period" name="period" required
                                        style="border: 1px solid #e5e7eb; border-radius: 0.5rem; padding: 0.75rem; transition: all 0.2s ease;"
                                        onfocus="this.style.borderColor='#9333ea'; this.style.boxShadow='0 0 0 0.2rem rgba(147, 51, 234, 0.25)';"
                                        onblur="this.style.borderColor='#e5e7eb'; this.style.boxShadow='none';">
                                    <option value="">Select lock period</option>
                                    <option value="7">1 Week</option>
                                    <option value="30">1 Month</option>
                                    <option value="60">2 Months</option>
                                    <option value="90">3 Months</option>
                                </select>
                            </div>

                            <button type="submit" class="btn w-100 py-3 fw-medium" id="submitBtn"
                                    style="background: linear-gradient(135deg, #9333ea, #db2777); border: none; color: white; border-radius: 0.5rem; transition: all 0.3s ease;"
                                    onmouseover="this.style.background='linear-gradient(135deg, #7c3aed, #be185d)'; this.style.transform='translateY(-1px)'; this.style.boxShadow='0 4px 12px rgba(147, 51, 234, 0.3)';"
                                    onmouseout="this.style.background='linear-gradient(135deg, #9333ea, #db2777)'; this.style.transform='none'; this.style.boxShadow='none';">
                                <i class="bi bi-piggy-bank me-2"></i>
                                <span id="btnText">Create Savings Goal</span>
                            </button>
                        </form>
                    </div>
                </div>
            </div>

            <!-- Savings History -->
            <div class="col-lg-6">
                <div class="card border-0 shadow-lg h-100" style="transition: transform 0.2s ease, box-shadow 0.2s ease;">
                    <div class="card-header border-0" style="background: linear-gradient(135deg, #eef2ff, #faf5ff); border-radius: 0.5rem 0.5rem 0 0 !important;">
                        <h5 class="card-title mb-1" style="color: #3730a3;">
                            <i class="bi bi-clock-history me-2"></i>
                            Your Savings History
                        </h5>
                        <p class="card-text text-muted small mb-0">
                            Track all your savings goals and their progress
                        </p>
                    </div>
                    <div class="card-body p-0">
                        <div id="savingsHistory" style="max-height: 400px; overflow-y: auto;">
                            <?php if (empty($savings)): ?>
                                <div style="padding: 3rem 2rem; text-align: center; color: #6b7280;">
                                    <i class="bi bi-piggy-bank d-block" style="font-size: 3rem; opacity: 0.5; margin-bottom: 1rem;"></i>
                                    <p class="mb-0">No savings goals yet. Create your first one!</p>
                                </div>
                            <?php else: ?>
                                <?php foreach ($savings as $saving): ?>
                                    <div style="padding: 1rem; border-bottom: 1px solid #f3f4f6; transition: background-color 0.2s ease;">
                                        <div class="d-flex justify-content-between align-items-start mb-3">
                                            <div>
                                                <h6 class="fw-semibold text-dark mb-1"><?php echo htmlspecialchars($saving['title'] ?? '-'); ?></h6>
                                                <p class="fs-5 fw-bold mb-0" style="color: #9333ea;">₦<?php echo number_format($saving['amount'], 2); ?></p>
                                            </div>
                                            <span style="<?php
                                                switch ($saving['status']) {
                                                    case 'active':
                                                        echo 'background-color: #dcfce7; color: #166534; border: 1px solid #bbf7d0;';
                                                        break;
                                                    case 'completed':
                                                        echo 'background-color: #dbeafe; color: #1e40af; border: 1px solid #bfdbfe;';
                                                        break;
                                                    case 'broken':
                                                        echo 'background-color: #fee2e2; color: #dc2626; border: 1px solid #fecaca;';
                                                        break;
                                                    default:
                                                        echo 'background-color: #f3f4f6; color: #374151; border: 1px solid #d1d5db;';
                                                }
                                            ?> padding: 0.25rem 0.5rem; border-radius: 0.375rem; font-size: 0.75rem; font-weight: 500;">
                                                <?php echo ucfirst($saving['status']); ?>
                                            </span>
                                        </div>
                                        <div class="row g-3 mb-3">
                                            <div class="col-6">
                                                <small class="text-muted">
                                                    <strong>Start:</strong> <?php echo htmlspecialchars($saving['start_date']); ?>
                                                </small>
                                            </div>
                                            <div class="col-6">
                                                <small class="text-muted">
                                                    <strong>End:</strong> <?php echo htmlspecialchars($saving['end_date']); ?>
                                                </small>
                                            </div>
                                        </div>
                                        <?php if ($saving['status'] === 'active'): ?>
                                            <form method="post" action="index.php?url=savings" style="display:inline;">
                                                <input type="hidden" name="break-savings" value="1">
                                                <input type="hidden" name="saving_id" value="<?php echo (int)$saving['id']; ?>">
                                                <button type="submit" class="btn btn-danger btn-sm w-100">
                                                    <i class="bi bi-exclamation-triangle me-2"></i>
                                                    Break Savings
                                                </button>
                                            </form>
                                        <?php endif; ?>
                                    </div>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>

       
    </div>
</div>

