<?php
session_start();
require_once __DIR__ . '/../core/Models/SubscriberModel.php';
header('Content-Type: application/json');

// You may need to adjust how you get the user ID depending on your auth system
$userId = $_SESSION['loginId'] ?? null;
if (!$userId) {
    echo json_encode(["error" => "Not authenticated"]);
    exit;
}

$model = new SubscriberModel();

// Main wallet
$profile = $model->getProfileInfo($userId);
$main_wallet = isset($profile->sWallet) ? $profile->sWallet : 0;

// Savings wallet (sum of active savings)
$savings_wallet = $model->getActiveSavingsTotal($userId);

// Savings history
$savings = $model->getUserSavings($userId);

// Format for frontend
foreach ($savings as &$s) {
    $s['amount'] = floatval($s['amount']);
    $s['start_date'] = date('Y-m-d', strtotime($s['start_date']));
    $s['end_date'] = date('Y-m-d', strtotime($s['end_date']));
}

$response = [
    'main_wallet' => floatval($main_wallet),
    'savings_wallet' => floatval($savings_wallet),
    'savings' => $savings
];
echo json_encode($response); 