<?php
header("Content-Type: application/json");

// Check if file exists
if (!isset($_FILES["profileImage"])) {
    echo json_encode(["status" => "error", "message" => "No file uploaded"]);
    exit;
}

$file = $_FILES["profileImage"];

// Validate file
if ($file["error"] !== 0) {
    echo json_encode(["status" => "error", "message" => "Upload error"]);
    exit;
}

$ext = strtolower(pathinfo($file["name"], PATHINFO_EXTENSION));
$allowed = ["jpg", "jpeg", "png", "gif", "webp"];

if (!in_array($ext, $allowed)) {
    echo json_encode(["status" => "error", "message" => "Invalid file type"]);
    exit;
}

// Upload directory
$uploadDir = __DIR__ . "/uploads/";

// Create folder if missing
if (!is_dir($uploadDir)) {
    mkdir($uploadDir, 0777, true);
}

// Final file path
$newFile = "profile_" . time() . "." . $ext;
$savePath = $uploadDir . $newFile;

// Move file
if (move_uploaded_file($file["tmp_name"], $savePath)) {

    // Full URL to give back to browser
    $url = dirname($_SERVER["REQUEST_SCHEME"] . "://" . $_SERVER["HTTP_HOST"] . $_SERVER["REQUEST_URI"]) . "/uploads/" . $newFile;

    echo json_encode(["status" => "success", "url" => $url]);
} else {
    echo json_encode(["status" => "error", "message" => "Failed to save file"]);
}
?>
