<?php
session_start();
require_once 'path/to/your/Model.php'; // adjust path accordingly

$model = new Model();
$dbh = $model->connect();

// Simulate logged-in user (replace this with your actual session logic)
if (!isset($_SESSION['user_id'])) {
    $_SESSION['user_id'] = 1; // Replace with actual user login logic
}

$userId = $_SESSION['user_id'];

// Handle avatar upload
$message = "";
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['avatar']) && $_FILES['avatar']['error'] == 0) {
    $uploadDir = 'uploads/avatars/';
    if (!is_dir($uploadDir)) {
        mkdir($uploadDir, 0755, true);
    }

    $fileName = basename($_FILES['avatar']['name']);
    $ext = strtolower(pathinfo($fileName, PATHINFO_EXTENSION));
    $allowed = ['jpg', 'jpeg', 'png', 'gif'];

    if (!in_array($ext, $allowed)) {
        $message = "Only JPG, JPEG, PNG & GIF files are allowed.";
    } else {
        $newFileName = uniqid("avatar_", true) . '.' . $ext;
        $targetPath = $uploadDir . $newFileName;

        if (move_uploaded_file($_FILES['avatar']['tmp_name'], $targetPath)) {
            $sql = "UPDATE users SET avatar = :avatar WHERE id = :id";
            $stmt = $dbh->prepare($sql);
            $stmt->bindParam(':avatar', $targetPath);
            $stmt->bindParam(':id', $userId);
            $stmt->execute();

            $message = "Profile image updated.";
        } else {
            $message = "Failed to upload file.";
        }
    }
}

// Get current avatar
$sql = "SELECT avatar FROM users WHERE id = :id";
$stmt = $dbh->prepare($sql);
$stmt->bindParam(':id', $userId);
$stmt->execute();
$user = $stmt->fetch(PDO::FETCH_ASSOC);

$avatarPath = $user['avatar'] ?: 'https://via.placeholder.com/100?text=Avatar';

?>

<!DOCTYPE html>
<html>
<head>
    <title>Update Profile Image</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            padding: 40p
